module Redmine
  module SyntaxHighlighting
    module Ultraviolet
      
      class << self
        require 'uv'
        
        def highlight_by_filename(text, filename)
          syntax = Uv.syntax_for_file(filename)
          if syntax.blank?
            ERB::Util.h(content)
          else
            html = Uv.parse(text.chomp, "xhtml", syntax.first.first, false, "active4d")
            match = html.match(/^<pre.*?>(.*?)<\/pre>$/m)
            match ? match.captures.first : html
          end
        end
        
        def highlight_by_language(text, language)
          if Uv.syntaxes.include?(language)
            html = Uv.parse(text, "xhtml", language, true, "active4d")
            match = html.match(/^<pre.*?>(.*?)<\/pre>$/m)
            match ? match.captures.first : html
          else
            ERB::Util.h(text)
          end
        end
        
        def theme
          "active4d" #=>make it configurable in future version
        end
      end
      
      class Assets < Redmine::Hook::ViewListener
        def view_layouts_base_html_head(context)
          stylesheet_link_tag("syntax/#{Redmine::SyntaxHighlighting::Ultraviolet.theme}", :plugin => "ultraviolet_highlighter")
        end
      end
    end
  end
end
